/*
 * Decompiled with CFR 0.152.
 */
package sheepy.util.text;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Base85 {
    private static final long Power4 = 52200625L;
    private static final long Power3 = 614125L;
    private static final long Power2 = 7225L;
    private static Encoder RFC1924ENCODER;
    private static Encoder Z85ENCODER;
    private static Encoder ASCII85ENCODER;
    private static Decoder RFC1924DECODER;
    private static Decoder Z85DECODER;
    private static Decoder ASCII85DECODER;

    private static void buildDecodeMap(byte[] encodeMap, byte[] decodeMap) {
        Arrays.fill(decodeMap, (byte)-1);
        byte len = (byte)encodeMap.length;
        for (byte i = 0; i < len; i = (byte)(i + 1)) {
            byte b = encodeMap[i];
            decodeMap[b] = i;
        }
    }

    public static Encoder getRfc1924Encoder() {
        if (RFC1924ENCODER == null) {
            RFC1924ENCODER = new Rfc1924Encoder();
        }
        return RFC1924ENCODER;
    }

    public static Decoder getRfc1924Decoder() {
        if (RFC1924DECODER == null) {
            RFC1924DECODER = new Rfc1924Decoder();
        }
        return RFC1924DECODER;
    }

    public static Encoder getZ85Encoder() {
        if (Z85ENCODER == null) {
            Z85ENCODER = new Z85Encoder();
        }
        return Z85ENCODER;
    }

    public static Decoder getZ85Decoder() {
        if (Z85DECODER == null) {
            Z85DECODER = new Z85Decoder();
        }
        return Z85DECODER;
    }

    public static Encoder getAscii85Encoder() {
        if (ASCII85ENCODER == null) {
            ASCII85ENCODER = new Ascii85Encoder();
        }
        return ASCII85ENCODER;
    }

    public static Decoder getAscii85Decoder() {
        if (ASCII85DECODER == null) {
            ASCII85DECODER = new Ascii85Decoder();
        }
        return ASCII85DECODER;
    }

    public static void main(String[] args) {
    }

    private static class Ascii85Decoder
    extends Decoder {
        private static final byte[] zeros = new byte[]{0, 0, 0, 0};
        private static final byte[] spaces = new byte[]{32, 32, 32, 32};
        private static final byte[] DECODE_MAP = new byte[127];

        private Ascii85Decoder() {
        }

        @Override
        public int calcDecodedLength(byte[] encoded_data, int offset, int length) {
            int i;
            int deflated = length;
            int len = offset + length;
            for (i = offset; i < len; i += 5) {
                if (encoded_data[i] != 122 && encoded_data[i] != 121) continue;
                deflated += 4;
                i -= 4;
            }
            if (i != len) {
                i -= 5;
                while (i < len && (encoded_data[i] == 122 || encoded_data[i] == 121)) {
                    deflated += 4;
                    i -= 4;
                }
            }
            return super.calcDecodedLength(null, 0, deflated);
        }

        @Override
        public boolean test(byte[] encoded_data, int offset, int length) {
            try {
                int deviation = 0;
                int len = offset + length;
                for (int i = offset; i < len; ++i) {
                    byte e = encoded_data[i];
                    if (DECODE_MAP[e] >= 0) continue;
                    if ((deviation + i - offset) % 5 != 0 || e != 122 && e != 121) {
                        return false;
                    }
                    deviation += 4;
                }
                super.calcDecodedLength(null, 0, length + deviation);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ignored) {
                return false;
            }
            return true;
        }

        @Override
        protected String getName() {
            return "Ascii85";
        }

        @Override
        protected byte[] getDecodeMap() {
            return DECODE_MAP;
        }

        @Override
        protected int _decode(byte[] in, int ri, int rlen, byte[] out, int wi) {
            int re = ri + rlen;
            int wo = wi;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            byte[] buf = buffer.array();
            byte[] decodeMap = this.getDecodeMap();
            int max = ri + rlen;
            int max2 = max - 4;
            while (ri < max) {
                while (ri < max && (in[ri] == 122 || in[ri] == 121)) {
                    byte[] src = null;
                    switch (in[ri++]) {
                        case 122: {
                            src = zeros;
                            break;
                        }
                        case 121: {
                            src = spaces;
                        }
                    }
                    System.arraycopy(src, 0, out, wi, 4);
                    wi += 4;
                }
                if (ri >= max2) break;
                this._putData(buffer, decodeMap, in, ri);
                ri += 5;
                System.arraycopy(buf, 0, out, wi, 4);
                wi += 4;
            }
            if (re == ri) {
                return wi - wo;
            }
            int leftover = this._decodeDangling(decodeMap, in, ri, buffer, re - ri);
            System.arraycopy(buf, 0, out, wi, leftover);
            return wi - wo + leftover;
        }

        static {
            Base85.buildDecodeMap(Ascii85Encoder.ENCODE_MAP, DECODE_MAP);
        }
    }

    public static class Z85Decoder
    extends Decoder {
        private static final byte[] DECODE_MAP = new byte[127];

        @Override
        protected String getName() {
            return "Z85";
        }

        @Override
        protected byte[] getDecodeMap() {
            return DECODE_MAP;
        }

        static {
            Base85.buildDecodeMap(Z85Encoder.ENCODE_MAP, DECODE_MAP);
        }
    }

    public static class Rfc1924Decoder
    extends Decoder {
        private static final byte[] DECODE_MAP = new byte[127];

        @Override
        protected String getName() {
            return "RFC1924";
        }

        @Override
        protected byte[] getDecodeMap() {
            return DECODE_MAP;
        }

        static {
            Base85.buildDecodeMap(Rfc1924Encoder.ENCODE_MAP, DECODE_MAP);
        }
    }

    public static abstract class Decoder {
        public int calcDecodedLength(String data) {
            return this.calcDecodedLength(data.getBytes(StandardCharsets.US_ASCII));
        }

        public int calcDecodedLength(byte[] data) {
            return this.calcDecodedLength(data, 0, data.length);
        }

        public int calcDecodedLength(byte[] data, int offset, int length) {
            if (length % 5 == 1) {
                throw new IllegalArgumentException(length + " is not a valid Base85/" + this.getName() + " data length.");
            }
            return (int)((double)length * 0.8);
        }

        public final String decode(String data) {
            return new String(this.decode(data.getBytes(StandardCharsets.US_ASCII)), StandardCharsets.UTF_8);
        }

        public final byte[] decode(byte[] data) {
            return this.decode(data, 0, data.length);
        }

        public final byte[] decodeToBytes(String data) {
            return this.decode(data.getBytes(StandardCharsets.US_ASCII));
        }

        public final byte[] decode(byte[] data, int offset, int length) {
            byte[] result = new byte[this.calcDecodedLength(data, offset, length)];
            try {
                int len = this._decode(data, offset, length, result, 0);
                if (result.length != len) {
                    return Arrays.copyOf(result, len);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.throwMalformed(ex);
            }
            return result;
        }

        public final int decode(byte[] data, int offset, int length, byte[] out, int out_offset) {
            int size = this.calcDecodedLength(data, offset, length);
            try {
                this._decode(data, offset, length, out, out_offset);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.throwMalformed(ex);
            }
            return size;
        }

        public byte[] decodeBlockReverse(byte[] data) {
            int size = Math.max(0, (int)Math.ceil((double)data.length * 0.8));
            byte[] result = new byte[size];
            this.decodeBlockReverse(data, 0, data.length, result, 0);
            return result;
        }

        public int decodeBlockReverse(byte[] data, int offset, int length, byte[] out, int out_offset) {
            int size = (int)Math.ceil((double)length * 0.8);
            BigInteger sum = BigInteger.ZERO;
            BigInteger b85 = BigInteger.valueOf(85L);
            byte[] map = this.getDecodeMap();
            try {
                int len = offset + length;
                for (int i = offset; i < len; ++i) {
                    sum = sum.multiply(b85).add(BigInteger.valueOf(map[data[i]]));
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.throwMalformed(ex);
            }
            System.arraycopy(sum.toByteArray(), 0, out, out_offset, size);
            return size;
        }

        public boolean test(String data) {
            return this.test(data.getBytes(StandardCharsets.US_ASCII));
        }

        public boolean test(byte[] data) {
            return this.test(data, 0, data.length);
        }

        public boolean test(byte[] encoded_data, int offset, int length) {
            return this._test(encoded_data, offset, length);
        }

        protected boolean _test(byte[] data, int offset, int length) {
            byte[] valids = this.getDecodeMap();
            try {
                int len = offset + length;
                for (int i = offset; i < len; ++i) {
                    byte e = data[i];
                    if (valids[e] >= 0) continue;
                    return false;
                }
                this.calcDecodedLength(data, offset, length);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException ex) {
                return false;
            }
            return true;
        }

        protected RuntimeException throwMalformed(Exception ex) {
            throw new IllegalArgumentException("Malformed Base85/" + this.getName() + " data", ex);
        }

        protected int _decodeDangling(byte[] decodeMap, byte[] in, int ri, ByteBuffer buffer, int leftover) {
            if (leftover == 1) {
                this.throwMalformed(null);
            }
            long sum = (long)decodeMap[in[ri]] * 52200625L + (long)decodeMap[in[ri + 1]] * 614125L + 85L;
            if (leftover >= 3) {
                sum += (long)decodeMap[in[ri + 2]] * 7225L;
                sum = leftover >= 4 ? (sum += (long)(decodeMap[in[ri + 3]] * 85)) : (sum += 7225L);
            } else {
                sum += 621350L;
            }
            buffer.putInt(0, (int)sum);
            return leftover - 1;
        }

        protected int _decode(byte[] in, int ri, int rlen, byte[] out, int wi) {
            int wo = wi;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            byte[] buf = buffer.array();
            byte[] decodeMap = this.getDecodeMap();
            int loop = rlen / 5;
            while (loop > 0) {
                this._putData(buffer, decodeMap, in, ri);
                System.arraycopy(buf, 0, out, wi, 4);
                --loop;
                wi += 4;
                ri += 5;
            }
            int leftover = rlen % 5;
            if (leftover == 0) {
                return wi - wo;
            }
            leftover = this._decodeDangling(decodeMap, in, ri, buffer, leftover);
            System.arraycopy(buf, 0, out, wi, leftover);
            return wi - wo + leftover;
        }

        protected void _putData(ByteBuffer buffer, byte[] map, byte[] in, int ri) {
            buffer.putInt(0, (int)((long)map[in[ri]] * 52200625L + (long)map[in[ri + 1]] * 614125L + (long)map[in[ri + 2]] * 7225L + (long)(map[in[ri + 3]] * 85) + (long)map[in[ri + 4]]));
        }

        protected abstract byte[] getDecodeMap();

        protected abstract String getName();
    }

    public static class Ascii85Encoder
    extends Encoder {
        private static final byte[] ENCODE_MAP = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstu".getBytes(StandardCharsets.US_ASCII);
        private boolean useZ = true;
        private boolean useY = true;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

        @Override
        protected byte[] getEncodeMap() {
            return ENCODE_MAP;
        }

        @Override
        public int calcEncodedLength(byte[] data, int offset, int length) {
            int result = super.calcEncodedLength(data, offset, length);
            if (this.useZ || this.useY) {
                ByteBuffer buffer = ByteBuffer.wrap(data);
                int len = offset + length - 4;
                for (int i = offset; i <= len; i += 4) {
                    if (this.useZ && data[i] == 0) {
                        if (buffer.getInt(i) != 0) continue;
                        result -= 4;
                        continue;
                    }
                    if (!this.useY || data[i] != 32 || buffer.getInt(i) != 0x20202020) continue;
                    result -= 4;
                }
            }
            return result;
        }

        public void setZeroCompression(boolean compress) {
            this.lock.writeLock().lock();
            try {
                this.useZ = compress;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public boolean getZeroCompression() {
            this.lock.readLock().lock();
            try {
                boolean bl = this.useZ;
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setSpaceCompression(boolean compress) {
            this.lock.writeLock().lock();
            try {
                this.useY = compress;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public boolean getSpaceCompression() {
            this.lock.readLock().lock();
            try {
                boolean bl = this.useY;
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int _encode(byte[] in, int ri, int rlen, byte[] out, int wi) {
            this.lock.readLock().lock();
            try {
                int n = super._encode(in, ri, rlen, out, wi);
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        protected int _writeData(long sum, byte[] map, byte[] out, int wi) {
            if (this.useZ && sum == 0L) {
                out[wi++] = 122;
            } else if (this.useY && sum == 0x20202020L) {
                out[wi++] = 121;
            } else {
                return super._writeData(sum, map, out, wi);
            }
            return wi;
        }
    }

    public static class Z85Encoder
    extends Encoder {
        private static final byte[] ENCODE_MAP = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.-:+=^!/*?&<>()[]{}@%$#".getBytes(StandardCharsets.US_ASCII);

        @Override
        protected byte[] getEncodeMap() {
            return ENCODE_MAP;
        }
    }

    public static class IPv6Encoder
    extends Encoder {
        private static final byte[] ENCODE_MAP = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~".getBytes(StandardCharsets.US_ASCII);

        @Override
        protected byte[] getEncodeMap() {
            return ENCODE_MAP;
        }
    }

    public static class Rfc1924Encoder
    extends Encoder {
        private static final byte[] ENCODE_MAP = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~".getBytes(StandardCharsets.US_ASCII);

        @Override
        protected byte[] getEncodeMap() {
            return ENCODE_MAP;
        }
    }

    public static abstract class Encoder {
        public int calcEncodedLength(String data) {
            return this.calcEncodedLength(data.getBytes(StandardCharsets.UTF_8));
        }

        public int calcEncodedLength(byte[] data) {
            return this.calcEncodedLength(data, 0, data.length);
        }

        public int calcEncodedLength(byte[] data, int offset, int length) {
            if (offset < 0 || length < 0) {
                throw new IllegalArgumentException("Offset and length must not be negative");
            }
            return (int)Math.ceil((double)length * 1.25);
        }

        public final String encode(String data) {
            return this.encodeToString(data.getBytes(StandardCharsets.UTF_8));
        }

        public final String encodeToString(byte[] data) {
            return new String(this.encode(data), StandardCharsets.US_ASCII);
        }

        public final String encodeToString(byte[] data, int offset, int length) {
            return new String(this.encode(data, offset, length), StandardCharsets.US_ASCII);
        }

        public final byte[] encode(byte[] data) {
            return this.encode(data, 0, data.length);
        }

        public final byte[] encode(byte[] data, int offset, int length) {
            int len;
            byte[] out = new byte[this.calcEncodedLength(data, offset, length)];
            if (out.length == (len = this._encode(data, offset, length, out, 0))) {
                return out;
            }
            return Arrays.copyOf(out, len);
        }

        public final int encode(byte[] data, int offset, int length, byte[] out, int out_offset) {
            int size = this.calcEncodedLength(data, offset, length);
            return this._encode(data, offset, length, out, out_offset);
        }

        public byte[] encodeBlockReverse(byte[] data) {
            int size = Math.max(0, (int)Math.ceil((double)data.length * 1.25));
            byte[] result = new byte[size];
            this.encodeBlockReverse(data, 0, data.length, result, 0);
            return result;
        }

        public int encodeBlockReverse(byte[] data, int offset, int length, byte[] out, int out_offset) {
            int size = (int)Math.ceil((double)length * 1.25);
            if (offset != 0 || length != data.length) {
                data = Arrays.copyOfRange(data, offset, offset + length);
            }
            BigInteger sum = new BigInteger(1, data);
            BigInteger b85 = BigInteger.valueOf(85L);
            byte[] map = this.getEncodeMap();
            for (int i = size + out_offset - 1; i >= out_offset; --i) {
                BigInteger[] mod = sum.divideAndRemainder(b85);
                out[i] = map[mod[1].intValue()];
                sum = mod[0];
            }
            return size;
        }

        protected int _encodeDangling(byte[] encodeMap, byte[] out, int wi, ByteBuffer buffer, int leftover) {
            long sum = (long)buffer.getInt(0) & 0xFFFFFFFFL;
            out[wi] = encodeMap[(int)(sum / 52200625L)];
            out[wi + 1] = encodeMap[(int)((sum %= 52200625L) / 614125L)];
            sum %= 614125L;
            if (leftover >= 2) {
                out[wi + 2] = encodeMap[(int)(sum / 7225L)];
                sum %= 7225L;
                if (leftover >= 3) {
                    out[wi + 3] = encodeMap[(int)(sum / 85L)];
                }
            }
            return leftover + 1;
        }

        protected int _encode(byte[] in, int ri, int rlen, byte[] out, int wi) {
            int wo = wi;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            byte[] buf = buffer.array();
            byte[] encodeMap = this.getEncodeMap();
            int loop = rlen / 4;
            while (loop > 0) {
                System.arraycopy(in, ri, buf, 0, 4);
                wi = this._writeData((long)buffer.getInt(0) & 0xFFFFFFFFL, encodeMap, out, wi);
                --loop;
                ri += 4;
            }
            int leftover = rlen % 4;
            if (leftover == 0) {
                return wi - wo;
            }
            buffer.putInt(0, 0);
            System.arraycopy(in, ri, buf, 0, leftover);
            return wi - wo + this._encodeDangling(encodeMap, out, wi, buffer, leftover);
        }

        protected int _writeData(long sum, byte[] map, byte[] out, int wi) {
            out[wi] = map[(int)(sum / 52200625L)];
            out[wi + 1] = map[(int)((sum %= 52200625L) / 614125L)];
            out[wi + 2] = map[(int)((sum %= 614125L) / 7225L)];
            out[wi + 3] = map[(int)((sum %= 7225L) / 85L)];
            out[wi + 4] = map[(int)(sum % 85L)];
            return wi + 5;
        }

        protected abstract byte[] getEncodeMap();

        public String getCharset() {
            return new String(this.getEncodeMap(), StandardCharsets.US_ASCII);
        }
    }
}

